/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.shutdown;

import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public class ShutdownRequest {
    public static final int TYPE_RESTART_APPLICATION = 1;
    public static final int TYPE_RESTART_CONSOLE = 2;
    public static final int TYPE_SHUTDOWN_CONSOLE = 3;
    public static final int TYPE_POWEROFF_CONSOLE = 4;
    private LocalizableText applicationName = null;
    private LocalizableText applicationMessage = null;
    private int requestType = 0;
    private Date requestDate = null;
    private boolean cancelable = true;
    private boolean deferred = false;
    private static final String TRACE_MASKT = "XSHTMGRT";
    private static final String TRACE_MASKF = "XSHTMGRF";
    private static final String TRACE_MASKD = "XSHTMGRD";

    public ShutdownRequest(LocalizableText applicationName, int requestType, LocalizableText applicationMessage, Date requestDate) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKF, "-> ShutdownRequest");
        if (applicationName == null) {
            throw new IllegalArgumentException("Invalid application name specified.");
        }
        this.applicationName = applicationName;
        switch (requestType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid request type specified.");
            }
        }
        this.requestType = requestType;
        this.applicationMessage = applicationMessage;
        this.requestDate = requestDate != null ? requestDate : new Date();
        Trace.trace(TRACE_MASKF, "<- ShutdownRequest");
    }

    public ShutdownRequest(LocalizableText applicationName, int requestType, LocalizableText applicationMessage) throws IllegalArgumentException {
        this(applicationName, requestType, applicationMessage, null);
        Trace.trace(TRACE_MASKF, "<> ShutdownRequest(Ltext, reqtype, Ltext");
    }

    public LocalizableText getApplicationName() {
        return this.applicationName;
    }

    public LocalizableText getApplicationMessage() {
        return this.applicationMessage;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public int getExitStatus() {
        int rc;
        Trace.trace(TRACE_MASKF, "-> getExitStatus");
        switch (this.getRequestType()) {
            case 1: {
                rc = 100;
                break;
            }
            case 3: {
                rc = 102;
                break;
            }
            case 4: {
                rc = 103;
                break;
            }
            default: {
                rc = 101;
            }
        }
        Trace.trace(TRACE_MASKF, "<- getExitStatus");
        return rc;
    }

    public String getFallbackCommand() {
        String cmd;
        switch (this.getRequestType()) {
            case 3: {
                cmd = "halt";
                break;
            }
            case 4: {
                cmd = "poweroff";
                break;
            }
            default: {
                cmd = "reboot";
            }
        }
        return cmd;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append("[Type=").append(this.requestType).append(", Application name=").append(this.applicationName.toString()).append(", Application message=").append(this.applicationMessage == null ? "null" : this.applicationMessage.toString()).append(", date=").append(this.requestDate.toString()).append(", cancelable=").append(this.isCancelable() ? "true]" : "false]").append(", deferred=").append(this.isDeferred() ? "true]" : "false]");
        return result.toString();
    }
}

